/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import replicatorg.app.Base;
import replicatorg.app.ui.BGPanel;
import replicatorg.drivers.EstimationDriver;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;

public class MachineStatusPanel
extends BGPanel
implements MachineListener {
    private static final long serialVersionUID = -6944931245041870574L;
    protected JLabel label = new JLabel();
    protected JLabel smallLabel = new JLabel();
    protected JLabel tempLabel = new JLabel();
    private boolean isBuilding = false;
    private static final Color BG_ERROR = new Color(255, 128, 96);
    private static final Color BG_READY = new Color(128, 255, 96);
    private static final Color BG_BUILDING = new Color(255, 239, 0);

    MachineStatusPanel() {
        Font smallFont = Base.getFontPref("status.font", "SansSerif,plain,10");
        this.smallLabel.setFont(smallFont);
        this.tempLabel.setFont(smallFont);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.label.setText("Not Connected");
        this.label.setAlignmentX(0.0f);
        this.add(this.label);
        this.smallLabel.setAlignmentX(0.0f);
        Box b = Box.createHorizontalBox();
        b.add(this.smallLabel);
        b.add(Box.createHorizontalGlue());
        b.add(this.tempLabel);
        b.setAlignmentX(0.0f);
        this.tempLabel.setAlignmentX(1.0f);
        this.add(b);
        this.add(Box.createVerticalGlue());
        FontMetrics smallMetrics = this.getFontMetrics(smallFont);
        int height = (smallMetrics.getAscent() + smallMetrics.getDescent()) * 3;
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
        this.setMinimumSize(new Dimension(0, height));
        int prefWidth = 80 * smallMetrics.charWidth('n');
        this.setPreferredSize(new Dimension(prefWidth, height));
        this.setBackground(BG_ERROR);
    }

    private void updatePanel(Color panelColor, String text, String smallText, String tempText) {
        this.setBackground(panelColor);
        this.label.setText(text);
        this.smallLabel.setText(smallText);
        this.tempLabel.setText(tempText);
    }

    public void updateMachineStatus(MachineStateChangeEvent evt) {
        MachineState.State state = evt.getState().getState();
        Color bgColor = null;
        switch (state) {
            case READY: {
                bgColor = BG_READY;
                break;
            }
            case BUILDING: 
            case BUILDING_OFFLINE: 
            case PAUSED: {
                bgColor = BG_BUILDING;
                break;
            }
            default: {
                bgColor = BG_ERROR;
            }
        }
        String text = evt.getMessage();
        if (text == null) {
            text = state.toString();
        }
        switch (state) {
            case BUILDING: 
            case BUILDING_OFFLINE: 
            case PAUSED: {
                this.isBuilding = true;
                break;
            }
            default: {
                this.isBuilding = false;
            }
        }
        this.updatePanel(bgColor, text, null, null);
    }

    public void updateBuildStatus(MachineProgressEvent event) {
        if (this.isBuilding) {
            double proportion = (double)event.getLines() / (double)event.getTotalLines();
            double percentComplete = (double)Math.round(proportion * 10000.0) / 100.0;
            double remaining = event.getEstimated() * (1.0 - proportion);
            if (event.getTotalLines() == 0) {
                remaining = 0.0;
            }
            String s = String.format("Commands:  %1$7d / %2$7d  (%3$3.2f%%)   |   Elapsed:  %4$s  |  Estimated Remaining:  %5$s", event.getLines(), event.getTotalLines(), percentComplete, EstimationDriver.getBuildTimeString(event.getElapsed(), true), EstimationDriver.getBuildTimeString(remaining, true));
            this.smallLabel.setText(s);
        }
    }

    @Override
    public void machineStateChanged(MachineStateChangeEvent evt) {
        final MachineStateChangeEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MachineStatusPanel.this.updateMachineStatus(e);
            }
        });
    }

    @Override
    public void machineProgress(MachineProgressEvent event) {
        final MachineProgressEvent e = event;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MachineStatusPanel.this.updateBuildStatus(e);
            }
        });
    }

    @Override
    public void toolStatusChanged(MachineToolStatusEvent event) {
        final MachineToolStatusEvent e = event;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double temperature = e.getTool().getCurrentTemperature();
                MachineStatusPanel.this.tempLabel.setText(String.format("Temp: %1$3.1f\u00b0C", temperature));
            }
        });
    }
}

